/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.item;

import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class ItemStackHandlerSlot
extends SingleStackStorage {
    private final int index;
    private final ItemStackHandler handler;
    private class_1799 stack;
    private class_1799 lastStack;
    private ItemVariant variant;

    public ItemStackHandlerSlot(int index, ItemStackHandler handler, class_1799 initial) {
        this.index = index;
        this.handler = handler;
        this.lastStack = initial.method_7972();
        this.setStack(initial);
        handler.initSlot(this);
    }

    protected boolean canInsert(ItemVariant itemVariant) {
        return this.handler.isItemValid(this.index, itemVariant, 1);
    }

    protected int getCapacity(ItemVariant itemVariant) {
        return this.handler.getStackLimit(this.index, itemVariant);
    }

    protected class_1799 getStack() {
        return this.stack;
    }

    protected void setStack(class_1799 stack) {
        this.stack = stack;
        this.variant = ItemVariant.of((class_1799)stack);
    }

    public void setNewStack(class_1799 stack) {
        this.setStack(stack);
        this.onFinalCommit();
    }

    public ItemVariant getResource() {
        return this.variant;
    }

    public int getIndex() {
        return this.index;
    }

    protected void onFinalCommit() {
        this.onStackChange();
        this.notifyHandlerOfChange();
    }

    protected void onStackChange() {
        this.handler.onStackChange(this, this.lastStack, this.stack);
        this.lastStack = PortingLib.DEBUG ? this.stack : this.stack.method_7972();
    }

    protected void notifyHandlerOfChange() {
        this.handler.onContentsChanged(this.index);
    }

    @Nullable
    public class_2487 save() {
        return this.stack.method_7960() ? null : this.stack.method_7953(new class_2487());
    }

    public void load(class_2487 tag) {
        this.setStack(class_1799.method_7915((class_2487)tag));
        this.onStackChange();
    }
}

